package com.elitesland.yst.production.sale.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * sku上架信息表DO
 *
 * @author : JS
 * @date : 2023-3-2
 */
@Data
@ApiModel(value = "sku上架信息表", description = "sku上架信息表")
public class ItmSkuPutawayRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * spu上架信息表ID
     */
    @ApiModelProperty(name = "spu上架信息表ID")
    private Long spuPutawayId;

    /**
     * 商品SPU_ID
     */
    @ApiModelProperty(name = "商品SPU_ID")
    private Long spuId;

    /**
     * 商品ID
     */
    @ApiModelProperty(name = "商品ID")
    private Long itemId;

    /**
     * 发货基地
     */
    @ApiModelProperty(name = "发货基地")
    private Long desId;

    /**
     * 上架状态
     */
    @ApiModelProperty(name = "上架状态")
    private String putawayStatus;

    /**
     * 商品渠道类型
     */
    @ApiModelProperty(name = "商品渠道类型")
    private String channelType;

    @ApiModelProperty(name = "Spu名称")
    private String spuName;

    @ApiModelProperty(name = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "标配")
    private String itemGroup2;

    @ApiModelProperty(name = "商品销售属性 配置")
    private String config;

    @ApiModelProperty(name = "商品销售属性 颜色")
    private String color;

    @ApiModelProperty(name = "车型名称")
    private String itemType5Name;

    @ApiModelProperty(value = "产品组 yst-supp:PRODUCT_TYPE")
    private String itemProduct;
}