package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.dto.ModifyStoreMobile;
import com.elitesland.yst.production.sale.dto.StoreAccountSaveRpcDTO;
import com.elitesland.yst.production.sale.dto.param.StoreAccountSaveRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = CrmCustAccountRpcService.URI)
public interface CrmCustAccountRpcService {
    String URI = Application.URI_PREFIX + "/custaccount";

    @GetMapping("/getCustAccountByUserId")
    CustAccountVO getCustAccountByUserId(@RequestParam("userName") Long userId);

    @GetMapping("/getCustAccountByCustCode")
    List<CustAccountVO> getCustAccountBycustCode(@RequestParam("custCodes") List<String> custCodes);


    /**
     * 保存或更新门店账号<br>
     * 更新时会更新联系电话及启停状态<br>
     *
     * @param param
     */
    @PostMapping("/saveStoreAccount")
    ApiResult<List<StoreAccountSaveRpcDTO>> saveStoreAccount(@RequestBody List<StoreAccountSaveRpcParam> param);

    @PostMapping("/modifyStoreMobile")
    ApiResult<String> modifyStoreMobile(@RequestBody ModifyStoreMobile modifyStoreMobile);

}
