package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.dto.PriBasePriceDTO;
import com.elitesland.yst.production.sale.dto.PriCrossPriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.query.PriBasePriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriCrossPriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * 销售价格对外提供服务
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/28 1:31 下午
 */
@FeignClient(name = Application.NAME, path = PriSalePriceRpcService.URI)
public interface PriSalePriceRpcService {
    String URI = Application.URI_PREFIX + "/saleprice";
    /**
     * 对外销售价格查询
     * @param param
     * @return
     */
	@PostMapping("/priSalePriceRpc/findSalePriceDto")
    ApiResult<PriSalePriceDTO> findSalePriceDto(PriSalePriceReqDTO param);

    /**
     * 对外销售价格批量查询
     * @param params
     * @return
     */
	@PostMapping("/priSalePriceRpc/findSalePriceListDto")
    ApiResult<List<PriSalePriceDTO>> findSalePriceListDto(List<PriSalePriceReqDTO> params) throws InterruptedException;


    /**
     * 内部结算价格查询接口
     * @param param
     * @return
     */
	@PostMapping("/priSalePriceRpc/findCrossPriceDto")
    ApiResult<PriCrossPriceDTO> findCrossPriceDto(PriCrossPriceReqDTO param);

    /**
     * B端基础价格查询
     * @param param
     * @return
     */
	@PostMapping("/priSalePriceRpc/findBasePriceDto")
    ApiResult<PriBasePriceDTO> findBasePriceDto(PriBasePriceReqDTO param);

    /**
     * 对外销售商品税率查询(客户价格税率)
     * @param param
     * @return
     */
	@PostMapping("/priSalePriceRpc/findSaleTaxRateDto")
    ApiResult<PriSalePriceDTO> findSaleTaxRateDto(PriSalePriceReqDTO param);

}
