package com.elitesland.yst.production.sale.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 客户价格.
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
@Data
public class BipCustPriceDTO implements Serializable {
    private static final long serialVersionUID = -8237009724434364020L;

    /**
     * 价格类型
     * [UDC]PRI:SALE_PRICE_TYPE
     */
    private String priceType;

    /**
     * 商品中心的商品ID
     */
    private Long itemId;

    /**
     * 商品中心的商品编号
     */
    private String itemCode;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 客户组(客户等级)
     * [UDC]CRM:CUST_GROUP
     */
    private String custGroup;

    /**
     * 含税价格
     */
    private BigDecimal price;

    /**
     * 不含税价格
     */
    private BigDecimal netPrice;

    /**
     * 生效时间
     */
    private LocalDateTime validFrom;

    /**
     * 失效时间
     */
    private LocalDateTime validTo;
}
