package com.elitesland.yst.production.sale.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/09/02
 */
@Data
public class BipItemSkuDTO implements Serializable {
    private static final long serialVersionUID = 6524545273953905814L;

    /**
     * 商品Id
     */
    private Long bipItemId;

    /**
     * 商品名称
     */
    private String itemName;

    /**
     * sku编号
     */
    private String skuCode;

    /**
     * 属性列表
     */
    private List<Attr> attrList;

    /**
     * 商品条码
     */
    private String barcode;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 批次
     */
    private String batch;

    /**
     * 基础价
     */
    private BigDecimal price;

    /**
     * 是否一件代发
     */
    private Boolean shipOne;

    /**
     * 供应商
     */
    private String supplier;

    /**
     * 库存
     */
    private Integer stock;

    /**
     * 最小起订量
     */
    private Integer limitBuy;

    @Data
    public static class Attr implements Serializable {
        private static final long serialVersionUID = -5984146393847027342L;

        /**
         * 属性编码
         */
        private String code;

        /**
         * 属性名称
         */
        private String name;

        /**
         * 属性值
         */
        private String value;
    }
}
