package com.elitesland.yst.production.sale.api.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalQuotationQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.*;


/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 20:52
 */
public interface SalQuotationService {

    /**
     * 根据分页查询参数分页查询报价单
     *
     * @param searchParam 分页查询参数
     * @return PagingVO<SalQuotationPageRespVO>
     */
    PagingVO<SalQuotationPageRespVO> search(SalQuotationQueryParamVO searchParam);

    /**
     * 提交销售报价单
     * @param salQuotationDetailRespVO salQuotationDetailRespVO
     * @return Long
     */
    Long submitSalQuotation(SalQuotationDetailRespVO salQuotationDetailRespVO);

    /**
     * 销售报价单保存
     *
     * @param salQuotationDetailRespVO 销售报价单保存参数
     * @return Long
     */
    Long createSalQuotation(SalQuotationDetailRespVO salQuotationDetailRespVO);

    /**
     * 导出数据查询拼接
     *
     * @param paramVO 销售报价单导出数据查询入参
     * @return 导出模板入参集合
     */
    ApiResult<PagingVO<SalQuotationExportVO>> searchForExport(SalQuotationQueryParamVO paramVO);

    /**
     * 根据销售报价单id查询报价单详情
     *
     * @param id 报价单id
     * @return SalQuotationDetailRespVO
     */
    SalQuotationDetailRespVO findSalQuotationById(Long id);
}