package com.elitesland.yst.production.sale.api.service;

import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerDtlSaveVO;

import java.util.List;

/**
 * <p>
 * 功能说明:销售业绩统计-经销商-明细
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/01
 * @Version 1.0
 * @Content:
 */
public interface StatisticsDealerDtlService {

    /**
     * 经销商销售业绩明细保存
     *
     * @param saveVOList 入参
     * @return 任务明细ID
     */
    List<Long> saveStatisticsDealerDtl(List<SaleStatisticsDealerDtlSaveVO> saveVOList);

    /**
     * 根据入参查询明细
     *
     * @param queryVO 入参
     * @return 明细出参
     */
    List<SaleStatisticsDealerDtlRespVO> selectByParam(SaleStatisticsDealerDtlQueryVO queryVO);

    /**
     * 根据入参查询主表ID
     *
     * @param queryVO 入参
     * @return 明细出参
     */
    List<SaleStatisticsDealerDtlRespVO> selectPidByQueryVO(SaleStatisticsDealerDtlQueryVO queryVO);

}
