package com.elitesland.yst.production.sale.api.service.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipCartParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFareAmtQueryParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartVo;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAPPRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.AttrAppParamVO;

import java.util.HashMap;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/16/14:43
 * @Description:
 */
public interface BipCartService {

    /**
     * 商品放入购物车
     *
     * @param bipCartParmVO
     */
    void addItemToCart(BipCartParmVO bipCartParmVO);

    /**
     * 购物车查询
     *
     * @return
     */
    BipCartVo findMyCart(Long ouId);

    /**
     * 获取运费信息
     * @param bipFareAmtQueryParmVO
     * @param bipFareAmtQueryParmVO
     * @return
     */
    HashMap<String,Object> findFeeFare(BipFareAmtQueryParmVO bipFareAmtQueryParmVO);


    /**
     * 购物车结算
     * @return
     */
    BipCartVo findMyCartEable(BipCartSettleParmVO bipCartSettleParmVO);


    /**
     * 立即购买结算
     * @param bipBuyNowSettleParmVO
     * @return
     */
    BipCartVo findBuyNowOrderPer(BipBuyNowSettleParmVO bipBuyNowSettleParmVO);

    /**
     * 购物车修改
     *
     * @param bipCartParmVO
     */
    void updateCart(BipCartParmVO bipCartParmVO);

    /**
     * 购物车删除
     *
     * @param idList
     */
    void deleteCart(List<Long> idList);


    List<AttrAPPRespVO> getAttrList(AttrAppParamVO attrAppParamVO);
}
