package com.elitesland.yst.production.sale.api.service.shop;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountGiftSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountGiftVO;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 满减赠折扣赠服务
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
public interface MktDiscountGiftService {
    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<MktDiscountGiftRespVO> search(MktDiscountGiftQueryVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    Optional<MktDiscountGiftRespVO> findCodeOne(String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    Optional<MktDiscountGiftRespVO> findIdOne(Long id);

    /**
     * 创建
     *
     * @param ；list 对象集合
     */
    List<Long> createBatch(List<MktDiscountGiftSaveVO> list);

    /**
     * 更新
     *
     * @param updateParam 对象
     */
    void update(MktDiscountGiftSaveVO updateParam);

    /**
     * 删除(物理删除)
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);

    /**
     * 删除明细
     *
     * @param idList 明细ID集合
     */
    void deleteDBatch(List<Long> idList);

    /**
     * 删除明细
     *
     * @param idList 赠品ID集合
     */
    void deleteGiftBatch(List<Long> idList);

    /**
     * 更新删除标识（逻辑删除）
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    /**
     * 批量更新删除标识（逻辑删除）
     *
     * @param ids id集合
     */
    void updateDeleteFlagBatch(List<Long> ids);

    /**
     * 审批
     *
     * @param ids        主表主键ID 集合
     * @param apprStatus 审批状态
     */
    void appr(List<Long> ids, String apprStatus);

    /**
     * 根据入参 查询符合条件的商品买赠折扣信息
     * @param ouId
     * @param customLevel 可为空
     * @param itemIds
     * @return
     */
    List<MktDiscountGiftVO> findMktDiscountGiftByParam(Long ouId, String customLevel, List<Long> itemIds);
}
