package com.elitesland.yst.production.sale.api.vo.param.crm;

import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Convert;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/20 13:44
 */
@Data
@ApiModel(description = "创建账户入参")
public class CrmCustAccountParam implements Serializable {
    private static final long serialVersionUID = 8043583108996644853L;

    @ApiModelProperty("客户编码")
    @NotBlank
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty(value = "经销商类型(一网/二网)")
    @NotBlank
    private String dealerType;

    @ApiModelProperty("业务类型(整车/配件)")
    private String businessType;

    @ApiModelProperty(value = "是否启用")
    private Boolean enable;

    @ApiModelProperty(value = "是否为子账号")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean subAcFlag;

    @ApiModelProperty(value = "账户手机号")
    @NotBlank
    private String mobile;

    @ApiModelProperty(value = "登录用户名")
    private String userName;

    @ApiModelProperty(value = "昵称")
    private String nickName;

    @ApiModelProperty(value = "角色id")
    private Long roleId;

    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    @ApiModelProperty(value = "是否新增: true:新增，flase:变更")
    private Boolean createFlag;

    @ApiModelProperty(value = "自定义数据来源")
    private String source;

    @ApiModelProperty(value = "旧的用户名")
    private String oldUserName;

    @ApiModelProperty("业务类型UDC[yst-sale:BUSINESS_TYPE]")
    private String businessTypeCust;
}
