package com.elitesland.yst.production.sale.api.vo.param.crm;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * .
 *
 * @author Evin.dong
 * @date 2021-05-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "客户弹框选择查询入参")
public class CrmCustPlugInParamVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -8525814237219243163L;
    @ApiModelProperty(value = "客户编号/名称")
    private String custData;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "业务员ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "项目公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "是否是内部用户 true: 是, false: 否")
    private Boolean innerFlag;
}
