package com.elitesland.yst.production.sale.api.vo.param.crm;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author cwb
 * @create 2022-04-20 11:02
 */
@ApiModel(description = "七陌展示客户主数据信息")
@Data
public class SevenCustVo implements Serializable {
    private static final long serialVersionUID = 5227112878291233500L;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "大B/小B [UDC]CRM:CUST_GROUP2")
    @SysCode(sys = "yst-sale", mod = "CUST_GROUP2")
    private String custGroup2;
    private String custGroup2Name;

    @ApiModelProperty(value = "客户分类 [UDC]CRM:CUST_TYPE")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE")
    private String custType;
    private String custTypeName;

    @ApiModelProperty("B端商城联系人姓名")
    private String contactName;

    @ApiModelProperty("B端商城联系人电话")
    private String contactPhone;
}
