package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 请求参数 - 内部结算价查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@Data
@ApiModel(description = "内部结算价查询请求参数")
public class PriCrossPriceQueryParam implements Serializable {

    @ApiModelProperty(value = "销售公司ID", required = true)
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "客户ID", required = true)
    @NotNull(message = "客户ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "区域", required = true)
    @NotBlank(message = "区域不得为空")
    private String region;

    @ApiModelProperty(value = "货币码", required = true)
    @NotBlank(message = "货币码不得为空")
    private String currCode;

    @ApiModelProperty(value = "商品集合", required = true)
    @NotEmpty(message = "查询商品集合不得为空")
    @Valid
    private List<PriSaleItemQueryParam> items;

}
