package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求参数 - 价格查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/5 3:08 下午
 */
@Data
@ApiModel(description = "价格查询商品信息封装")
public class PriSaleItemQueryParam implements Serializable {
    private static final long serialVersionUID = 8935718607392125012L;

    @ApiModelProperty(value = "商品ID", required = true)
    @NotNull(message = "商品ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "计量单位", required = true)
    @NotBlank(message = "计量单位不得为空")
    private String uom;

}
