package com.elitesland.yst.production.sale.api.vo.param.pri;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 请求参数
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 2:13 下午
 */
@Data
@ApiModel(description = "价格请求参数")
public class PriSalePriceQueryOneParam implements Serializable {

    private static final long serialVersionUID = 3225468425124415826L;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "公司ID不得为空")
    private Long ouId;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "区域")
    private String saleRegion;

    @ApiModelProperty(value = "客户组（客户等级）")
    private String custGroup;

    @ApiModelProperty(value = "商品ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    @NotNull(message = "商品ID不得为空")
    private Long itemId;

    @ApiModelProperty(value = "币种", required = true)
    private String currCode;

    @ApiModelProperty(value = "价格类型", required = true)
    private String priceType;

}
