package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 请求参数 - 合同验收保存或提交
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 10:13
 */
@Data
@ApiModel(description = "合同验收保存或提交参数")
public class SalAcceptanceSaveParam implements Serializable {

    private static final long serialVersionUID = -2044866380115936219L;

    @ApiModelProperty(value = "验收单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "验收单号")
    private String docNo;

    @ApiModelProperty(value = "公司ID", required = true)
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售组织ID", required = true)
    @NotNull(message = "销售组织ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "公司编码", required = true)
    @NotBlank(message = "公司编码不得为空")
    private String ouCode;

    @ApiModelProperty(value = "客户ID", required = true)
    @NotNull(message = "客户ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "客户编码", required = true)
    @NotBlank(message = "客户编码不得为空")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty(value = "申请日期")
    private LocalDate applyDate;

    @ApiModelProperty(value = "申请人ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;


    @ApiModelProperty(value = "验收日期")
    private LocalDate acDate;

    @ApiModelProperty("状态")
    private String acStatus;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("项目编号")
    private String projNo;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty(value = "验收金额（含税）", required = true)
    @NotNull(message = "验收金额不得为空")
    private BigDecimal amt;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("附件信息")
    List<ComSaleFileComVO> fileComVOS;

    @ApiModelProperty("合同验收单明细")
    private List<SalAcceptanceDSaveParam> details;

}
