package com.elitesland.yst.production.sale.api.vo.param.pro;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 查询参数 - 销售项目
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 8:16 下午
 */
@Data
@ApiModel(description = "销售项目查询请求参数")
public class SalProjQueryParam implements Serializable {

    private static final long serialVersionUID = 371536549905361417L;

    @ApiModelProperty(value = "项目ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty(value = "项目ID集合")
    private List<Long> ids;

    @ApiModelProperty(value = "项目编码")
    private String projNo;
    @ApiModelProperty(value = "项目编码集合")
    private List<String> projNos;

    @ApiModelProperty(value = "项目名称")
    private String projName;

    @ApiModelProperty(value = "项目分类")
    private String projType;

    @ApiModelProperty(value = "项目状态")
    private String projStatus;

    @ApiModelProperty(value = "客户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty(value = "OuID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

}
