package com.elitesland.yst.production.sale.api.vo.param.sal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 业绩提成规则(SalCommissionRule)实体类
 *
 * @author makejava
 * @since 2021-11-22 17:55:34
 */
@Data
@ApiModel(value = "sal_commission_rule", description = "业绩提成规则")
public class SalCommissionRuleCreateParam implements Serializable {
    private static final long serialVersionUID = -77318879781223614L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;
    /**
     * 公司编号
     */
    @ApiModelProperty("公司编号")
    private String ouCode;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;
    /**
     * 商品品类编号
     */
    @ApiModelProperty("商品品类编号")
    private String itemCateCode;

    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 提成规则 UDC:SAL/COMMISSION_RULE
     */
    @ApiModelProperty("提成规则 UDC:SAL/COMMISSION_RULE")
    private String commissionRule;
    /**
     * 提成百分比
     */
    @ApiModelProperty("提成百分比")
    private BigDecimal percentage;
    /**
     * 计件提成每件提成（元）
     */
    @ApiModelProperty("计件提成每件提成（元）")
    private BigDecimal pieceWage;

}
