package com.elitesland.yst.production.sale.api.vo.param.sal;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 19:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "销售报价单查询入参")
public class SalQuotationQueryParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 8583880086342692277L;

    @ApiModelProperty(value = "销售报价单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    private List<Long> ids;

    @ApiModelProperty(value = "客户类型")
    private String qtCustType;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "业务员")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "报价日期")
    private LocalDateTime beginQuotationDate;
    private LocalDateTime endQuotationDate;

    @ApiModelProperty(value = "报价单状态")
    private String quotationStatus;

    @ApiModelProperty(value = "审批日期")
    private LocalDateTime beginApprTime;
    private LocalDateTime endApprTime;

    @ApiModelProperty(value = "审批人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty(value = "报价单单号")
    private String docNo;

    @ApiModelProperty(value = "区域")
    private String saleRegion;

    @ApiModelProperty(value = "是否只查询审批通过/审批拒绝, true:只查询审批通过和审批拒绝, false:查询全部的数据(app使用)")
    private Boolean ifCheckApprovalFlag;

}
