package com.elitesland.yst.production.sale.api.vo.param.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 发票明细表(BipInv)实体类
 *
 * @author joker xing
 * @since 2021-09-06 13:51:26
 */

@Data
@ApiModel(value = "bip_inv", description = "发票明细表")
public class BipInvCreateParam implements Serializable {
    private static final long serialVersionUID = 736651197454833368L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 订单编号s
     */
    @ApiModelProperty("订单编号s")
    private List<String> docNos;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单ID")
    private Long orderId;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invNo;
    /**
     * 发票编码
     */
    @ApiModelProperty("发票编码")
    private String invCode;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型--现在只能开 增值税电子普通发票")
    private String invType;
    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String bank;
    /**
     * 企业地址
     */
    @ApiModelProperty("企业地址")
    private String companyAddress;
    /**
     * 企业电话
     */
    @ApiModelProperty("企业电话")
    private String companyTel;
    /**
     * 银行账户
     */
    @ApiModelProperty("银行账户")
    private String bankAccount;
    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private String ownedCompany;
    /**
     * 抬头类型
     */
    @ApiModelProperty("抬头类型")
    private String invTitleType;
    /**
     * 总金额--开票金额
     */
    @ApiModelProperty("总金额--开票金额")
    private BigDecimal totalAmt;
    /**
     * 用户id
     */
    @ApiModelProperty("用户id--由前端传入")
    private Long custAccountId;
    /**
     * 下单时间
     */
    @ApiModelProperty("下单时间")
    private LocalDateTime orderTime;

    /**
     * 新加字段 开票zhao.zhi.hao
     */
    @ApiModelProperty("推送方式  -1,不推送;0,邮箱(写死);1,手机（默认）;2,邮箱、手机")
    private String pushMode;

    @ApiModelProperty("手机号")
    private String buyerPhone;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("开票类型")
    private String invoiceType;

    @ApiModelProperty("发票类型")
    private String invoiceLine;

    @ApiModelProperty("发票单流水号")
    private String invSerialNum;

    @ApiModelProperty("是否进行税率分组")
    private Integer invMultipleTax;

    @ApiModelProperty("发票状态")
    private String status;
    @ApiModelProperty("是否红票")
    private String isRed;
    @ApiModelProperty("红票流水号")
    private String redInvSerialNum;

}


