package com.elitesland.yst.production.sale.api.vo.param.shop;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 发票明细表(BipInv)实体类
 *
 * @author Joker (Xing Shixiang)
 * @since 2021-09-06 13:51:26
 */

@Data
@ApiModel(value = "bip_inv", description = "发票明细表")
public class BipInvUpdateParam implements Serializable {
    private static final long serialVersionUID = 756486341421409345L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 订单ID
     */
    @ApiModelProperty("订单ID")
    private Long docNo;
    /**
     * 发票代码
     */
    @ApiModelProperty("发票代码")
    private String invNo;
    /**
     * 发票编码
     */
    @ApiModelProperty("发票编码")
    private String invCode;
    /**
     * 发票类型
     */
    @ApiModelProperty("发票类型")
    private String invType;
    /**
     * 发票抬头
     */
    @ApiModelProperty("发票抬头")
    private String invTitle;
    /**
     * 税号
     */
    @ApiModelProperty("税号")
    private String taxNo;
    /**
     * 开户银行
     */
    @ApiModelProperty("开户银行")
    private String bank;
    /**
     * 企业地址
     */
    @ApiModelProperty("企业地址")
    private String companyAddress;
    /**
     * 企业电话
     */
    @ApiModelProperty("企业电话")
    private String companyTel;
    /**
     * 银行账户
     */
    @ApiModelProperty("银行账户")
    private String bankAccount;
    /**
     * 所属公司
     */
    @ApiModelProperty("所属公司")
    private String ownedCompany;
    /**
     * 抬头类型
     */
    @ApiModelProperty("抬头类型")
    private String invTitleType;
    /**
     * 总金额
     */
    private BigDecimal totalAmt;
}
