package com.elitesland.yst.production.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Convert;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/19/15:02
 * @Description:
 */
@Data
@ApiModel(description = "商品评价分页查询入参")
public class BipItemEvalParmVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = 4624059135136279691L;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品id")
    private Long itemId;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("客户公司编码")
    private String ouCode;

    @ApiModelProperty("客户所属公司名称")
    private String ouName;

    @ApiModelProperty("商品评分")
    private Integer itemEvalScore;


    @ApiModelProperty("物流评分")
    private Integer logicEvalScore;


    @ApiModelProperty("是否显示")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isShow;

    @ApiModelProperty("评价图片code")
    private String evalPicFileCodes;
}
