package com.elitesland.yst.production.sale.api.vo.param.shop;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 赠品 查询VO
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@ApiModel(description = "赠品 查询VO")
@Data
public class MktGiftQueryVO extends AbstractOrderQueryParam {

    private static final long serialVersionUID = 208026268955623149L;

    @ApiModelProperty("买赠折扣编码")
    private String discountGiftCode;

    @ApiModelProperty(value = "买赠明细商品id")
    private Long discountGiftItemId;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("促销生效时间")
    private LocalDateTime validStime;

    @ApiModelProperty("促销失效时间")
    private LocalDateTime validEtime;

}
