package com.elitesland.yst.production.sale.api.vo.param.taskinfo;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/20
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "APP端任务查询入参")
public class TaskInfoAppQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -5687086877725183449L;

    @ApiModelProperty("是否全部明细状态:true 是,false 否")
    private Boolean allStateSign;

    @ApiModelProperty("任务名称/执行人模糊查询")
    private String queryKeyword;

    @ApiModelProperty("执行人code")
    private String executUserCode;
    @ApiModelProperty("执行人code集合-后端组装条件使用-不显示给前端")
    @JsonIgnore
    private List<String> executUserCodes;
    @ApiModelProperty("执行人code集合-后端组装条件(仅供根据执行人名称进行模糊查询使用)-不显示给前端")
    @JsonIgnore
    private List<String> executUserCodeList;

    @ApiModelProperty("明细完成状态")
    private String completeState;
    @ApiModelProperty("明细完成状态集合-后端组装条件使用-不显示给前端")
    @JsonIgnore
    private List<String> completeStates;

    @ApiModelProperty("明细是否逾期")
    private String delayFlag;

    @ApiModelProperty("任务类型")
    private String type;
    @ApiModelProperty("任务类型集合-后端组装条件使用或显示给前端")
    private List<String> typeList;

    @ApiModelProperty(value = "业务员员工ID")
    private Long employeeId;

    //@ApiModelProperty(value = "业务员ID")
   // private Long agentEmpId;
    /******明细查询条件******/
    @ApiModelProperty("业务编码/名称模糊查询")
    private String businessKeyword;

    @ApiModelProperty("执行记录模糊查询")
    private String executRecordKeyword;
    /******明细查询条件******/
}
