package com.elitesland.yst.production.sale.api.vo.resp.crm;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@NoArgsConstructor
public class LmSaveCustRespVO implements Serializable {

    private static final long serialVersionUID = 7799329820797724758L;
    @ApiModelProperty(value = "id")
    private Long id;
    @ApiModelProperty(value = "客户编码")
    private String custCode;
    @ApiModelProperty(value = "客户名称")
    private String custName;
    @ApiModelProperty(value = "客户号")
    private String custCode2;
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty(value = "联系人")
    private String contactName;
    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty(value = "业务员")
    private Long agentEmpId;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "开票抬头")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTypeName;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;
    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    @ApiModelProperty("币种")
    private String custCurr;

    @ApiModelProperty("税号")
    private String taxerNo;

    @ApiModelProperty("父客户编号")
    private String pid;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "区域")
    private String region;

    @ApiModelProperty(value = "客户类型")
    private String custType;

    @ApiModelProperty(value = "对应公司")
    private String corOu;

    @ApiModelProperty(value = "法人代表")
    private String legalRepre;


    @ApiModelProperty(value = "外部客户编码")
    private String outerCode;

    @ApiModelProperty(value = "状态")
    private String custStatus;

    @ApiModelProperty("返利使用比例")
    private BigDecimal rebateUsageRatio;
    @ApiModelProperty("是否开启门店下单")
    private Boolean storeOrderFlag = true;
}
