package com.elitesland.yst.production.sale.api.vo.resp.menu;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


@Data
@ApiModel(description = "小程序首页配置列表")
public class BusFirstMenuConfVO implements Serializable {

	private static final long serialVersionUID = 1805047560430975866L;
	@ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("菜单编码")
    private String menuNo;

    @ApiModelProperty("菜单名称")
    private String menuName;


    @ApiModelProperty("图标")
    private String imgSign;


    @ApiModelProperty("排序")
    private Integer menuSort;


    @ApiModelProperty("所属公司")
    private Long ouId;


    @ApiModelProperty("所属公司名称")
    private String ouName;


    @ApiModelProperty("状态")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String status;
    private String statusName;

    @ApiModelProperty("secOuId")
    private Long secOuId;



    private List<BusFirstMenuConfDVO> list;
}
