package com.elitesland.yst.production.sale.api.vo.resp.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 返回参数 - 合同验收分页查询返回
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 09:57:48
 */
@ApiModel(description = "合同验收分页查询返回参数")
@Data
public class SalAcceptancePageRespVO implements Serializable {

    private static final long serialVersionUID = 1875272922898039302L;

    @ApiModelProperty("主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("验收单号")
    private String docNo;

    @ApiModelProperty("公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户")
    private String custName;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty("验收金额")
    private BigDecimal amt;

    @ApiModelProperty("状态 [UDC] SAL:AC_STATUS")
    @SysCode(sys = "yst-sale",mod = "AC_STATUS")
    private String acStatus;
    private String acStatusName;

    @ApiModelProperty("验收日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate acDate;

    @ApiModelProperty("申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty("申请人id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人name")
    private String applyEmpName;

}
