package com.elitesland.yst.production.sale.api.vo.resp.pro;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 返回参数 - 项目合同分页查询
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 7:21 下午
 */
@ApiModel(description = "项目合同分页查询返回参数")
@Data
public class SalContractPageRespVO implements Serializable {

    private static final long serialVersionUID = -7988495247117046710L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同类型")
    @SysCode(sys = "yst-sale", mod = "CONTRACT_TYPE")
    private String contractType;
    private String contractTypeName;

    @ApiModelProperty("合同状态")
    @SysCode(sys = "yst-sale", mod = "CONTRACT_STATUS")
    private String contractStatus;
    private String contractStatusName;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("合同版本")
    private Integer contractVersion;

    @ApiModelProperty("项目名称")
    private String projName;

    @ApiModelProperty(value = "签约日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate signDate;

    @ApiModelProperty(value = "开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate beginDate;

    @ApiModelProperty(value = "结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endDate;

    @ApiModelProperty("合同总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;

    @ApiModelProperty("客户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户编号")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户类别")
    private String custType;

    @ApiModelProperty("签约公司")
    private String bSignOu;
    private String bSignOuName;

    @ApiModelProperty("签约部门")
    private String bSignDept;
    private String bSignDeptName;

    @ApiModelProperty("销售员")
    private String bSalesman;
    private String bSalesmanName;

    @ApiModelProperty("来源单据类型")
    private String rootDocType;

    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp",mod = "DOC_CLS")
    private String rootDocCls;
    private String rootDocClsName;

    @ApiModelProperty("质保金尾款")
    private BigDecimal endAmt;

}
