package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @auther JinXK
 * @date 2021/9/30 17:42
 */
@Data
@ApiModel(value = "InvAwaitCustDetailsVO", description = "结算中心DTO")
public class BipInvAwaitCustDetailsVO implements Serializable {
    @ApiModelProperty("发票号码")
    String invNo;
    @ApiModelProperty("发票代码")
    String invCode;
    @ApiModelProperty("流水号")
    String flowNo;
    @ApiModelProperty("是否作废")
    Boolean state;
    @ApiModelProperty("是否红冲")
    Boolean isRed;
    @ApiModelProperty("发票PDF地址")
    String invPdfAddress;
    @ApiModelProperty("纸票PDF地址")
    String paperPdfAddress;
    @ApiModelProperty("校验码")
    String checkCode;
    @ApiModelProperty("错误原因")
    String errorReason;
    @ApiModelProperty("快递单号")
    String expressNumber;
    @ApiModelProperty("发票状态")
    @SysCode(sys = "FIN", mod = "INV_STATE")
    String invState;
    String invStateName;
    @ApiModelProperty("来源ID")
    String sourceId;
    @ApiModelProperty("合计税额")
    BigDecimal taxAmount;
    @ApiModelProperty("不含税金额")
    BigDecimal exTaxAmount;
    @ApiModelProperty("价税合计")
    BigDecimal orderAmount;
}
