package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @auther JinXK
 * @date 2021/7/19 9:52
 */
@Data
@ApiModel(description = "退货单明细查询出参")
public class RmiReSoDVO implements Serializable {
    private static final long serialVersionUID = -6336149984005639735L;

    @ApiModelProperty("退货订单号")
    private String docNo;
    @ApiModelProperty("退货订单类型")
    private String docType;
    @ApiModelProperty("退货订单行ID")
    private Long soDId;
    @ApiModelProperty("销售公司")
    private Long ouId;
    private String ouName;
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    @ApiModelProperty("税额")
    private BigDecimal soTaxAmt;
    @ApiModelProperty("税率编号")
    private String soTaxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal soTaxRate;
    @ApiModelProperty("商品id")
    private Long itemId;
    @ApiModelProperty("商品编号")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品品牌")
    private String itemBrand;
    @ApiModelProperty("品牌名称")
    private String itemBrandName;
    @ApiModelProperty("商品规格")
    private String itemSpec;
    @ApiModelProperty("计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    @ApiModelProperty("未含税单价")
    private BigDecimal netPrice;
    @ApiModelProperty("申请退货数量")
    private BigDecimal qty;
    @ApiModelProperty("实际退货数量")
    private BigDecimal confirmQty;
    @ApiModelProperty("申请退货金额(含税)")
    private BigDecimal amt;
    @ApiModelProperty("申请退货金额(未税)")
    private BigDecimal netAmt;
    @ApiModelProperty("实际退货金额")
    private BigDecimal confirmAmt;
    @ApiModelProperty("批准退款金额")
    private BigDecimal refundAmt;
    @ApiModelProperty("待退款金额")
    private BigDecimal openAmt;
    @ApiModelProperty("退款中金额")
    private BigDecimal payingAmt;
    @ApiModelProperty("已退款金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("单据类型")
    private BigDecimal docCls;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;
}
