package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/9 13:36
 */
@ApiModel(description = "公司详细信息")
@Data
public class SalOuDetailRespVO implements Serializable {

    private static final long serialVersionUID = 8329120252118178217L;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司编号")
    private String ouCode;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司简称")
    private String ouAbbr;

    @ApiModelProperty("字母缩写")
    private String abbrAlpha;

    @ApiModelProperty("公司类型")
    private String ouType;

    @ApiModelProperty("公司状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String ouStatus;

    @ApiModelProperty("法人公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long legalOuId;

    @ApiModelProperty("本位币")
    private String ouCurr;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "联系人手机")
    private String mobile;

    @ApiModelProperty(value = "联系人电话")
    private String tel;

    @ApiModelProperty(value = "联系人传真")
    private String fax;

    @ApiModelProperty(value = "联系人邮箱")
    private String email;

    @ApiModelProperty(value = "详细地址")
    private String detailAddr;

}
