package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-07-28 17:41
 */
@ApiModel(description = "支付押金退回出参")
@Data
public class SalPayDepositReturnRespVO implements Serializable {
	private static final long serialVersionUID = 4406789299601680378L;
	@ApiModelProperty("退押金id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("退押金单号")
    private String docNo;

    @ApiModelProperty("支付押金订单类型 [UDC]SAL:PD_TYPE")
    @SysCode(sys = "yst-sale", mod = "PD_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("客户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("合同编号")
    private String contractCode;

    @ApiModelProperty("合同名称")
    private String contractName;

//    @ApiModelProperty("押金金额")
//    private BigDecimal amt;

    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;

    @ApiModelProperty("要求支付日期")
    private LocalDateTime demandPaymentDate;

//    @ApiModelProperty("预计退还日期")
//    private LocalDateTime planReturnDate;

    @ApiModelProperty("实际还款日期")
    private LocalDateTime returnDate;

    @ApiModelProperty("开户银行ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bankId;

    @ApiModelProperty("开户银行name")
    private String bankName;

    @ApiModelProperty("银行支行")
    private String bankCode;

    @ApiModelProperty("银行账户")
    private String bankAcc;

    @ApiModelProperty("客户联系人")
    private String custContactName;

    @ApiModelProperty("客户联系人电话")
    private String custContactTel;

    @ApiModelProperty("申请人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人名字")
    private String applyName;

    @ApiModelProperty("退押金单状态 [UDC]SAL:RECEIPT_STATUS")
    @SysCode(sys = "yst-sale", mod = "RECEIPT_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("审核人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;

    @ApiModelProperty("审核人名称")
    private String apprUserName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("押金说明")
    private String depositDescription;

    @ApiModelProperty("销售公司")
    private String ouName;

    @ApiModelProperty("销售公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("支付方式 [UDC]SAL:REFOUND_METHOD")
    @SysCode(sys = "yst-sale", mod = "REFOUND_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty("销售区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty("退押金金额(退押金)")
    private BigDecimal returnAmt;

    @ApiModelProperty("原押金余额(每次查询时获取)")
    private BigDecimal openAmt;


    @ApiModelProperty("相关单据编号 原始单号(支付押金单号)")
    private String relateDocNo;

    @ApiModelProperty("销售组织")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("销售组织名称")
    private String buName;
}
