package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/15 19:35
 */
@ApiModel(description = "销售报销单")
@Data
public class SalQuotationPageRespVO implements Serializable {

    private static final long serialVersionUID = -6480050356915157487L;
    @ApiModelProperty(value = "销售报价单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "销售报价单单号")
    private String docNo;

    @ApiModelProperty(value = "客户类型 [UDC]SAL:QT_TYPE")
    @SysCode(sys = "yst-sale", mod = "QT_TYPE")
    private String qtCustType;
    private String qtCustTypeName;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "客户名称")
    private String custName;

    @ApiModelProperty(value = "公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    private String ouName;

    @ApiModelProperty(value = "仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    private String whName;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    private String buName;

    @ApiModelProperty(value = "报价人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;
    private String agentEmpName;

    @ApiModelProperty(value = "币种")
    private String currCode;
    private String currCodeName;

    @ApiModelProperty(value = "报价日期")
    private LocalDateTime quotationDate;

    @ApiModelProperty(value = "报价单状态 [UDC]SAL:QUOTATION_STATUS")
    @SysCode(sys = "yst-sale", mod = "QUOTATION_STATUS")
    private String quotationStatus;
    private String quotationStatusName;

    @ApiModelProperty("销售区域 [UDC]ORG:OU_REGION")
    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    private String saleRegion;
    private String saleRegionName;

    @ApiModelProperty(value = "审批日期")
    private LocalDateTime apprTime;

    @ApiModelProperty(value = "审批人")
    private Long apprUserId;
    private String apprUserName;

    @ApiModelProperty(value = "应税总金额")
    private BigDecimal netAmt;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal amt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "付款方式 [UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payMethod;
    private String payMethodName;

    @ApiModelProperty(value = "客户联系人")
    private String custContactName;

    @ApiModelProperty(value = "联系人电话")
    private String custContactTel;

    @ApiModelProperty(value = "收货地址")
    private String recvDetailaddr;

    @ApiModelProperty(value = "货运方式 [UDC]SAL:SO_DELIVER_METHOD")
    @SysCode(sys = "yst-sale", mod = "SO_DELIVER_METHOD")
    private String deliverMethod;
    private String deliverMethodName;

    @ApiModelProperty(value = "交货日期")
    private LocalDateTime demandTimespan;
}
