package com.elitesland.yst.production.sale.api.vo.resp.sal;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @auther JinXK
 * @date 2021/7/7 9:52
 */
@Data
@ApiModel(description = "客户对账单明细参数(通用)")
public class SalSoaDRespVO implements Serializable {
    private static final long serialVersionUID = -5296870170616890863L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "对账单号")
    private String docNo;

    @ApiModelProperty(value = "行号")
    private BigDecimal lineNo;

    @ApiModelProperty(value = "客户ID")
    private Long custId;

    @ApiModelProperty(value = "行状态")
    private String lineStatus;

    @ApiModelProperty(value = "订单ID")
    private Long soId;

    @ApiModelProperty(value = "销售订单编号")
    private String soNo;

    @ApiModelProperty(value = "销售订单明细ID")
    private Long soDId;

    @ApiModelProperty(value = "销售订单行号")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "单据类别 [UDC]SAL:SO_TYPE")
    @SysCode(sys = "yst-sale", mod = "SO_TYPE")
    private String docCls;
    private String docClsName;

    @ApiModelProperty(value = "订单编号")
    private String doDocNo;

    @ApiModelProperty(value = "发货单编号")
    private Long dodId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称2")
    private String itemName;

    @ApiModelProperty(value = "商品规格")
    private String itemSpec;

    @ApiModelProperty(value = "品牌")
    private String itemBrand;

    @ApiModelProperty(value = "订单数量")
    private BigDecimal soQty;

    @ApiModelProperty(value = "单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String soUom;
    private String soUomName;

    @ApiModelProperty(value = "税率编号")
    private String soTaxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal soTaxRate;

    @ApiModelProperty(value = "含税金额")
    private BigDecimal soAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal soTaxAmt;

    @ApiModelProperty(value = "发货数量")
    private BigDecimal doQty;

    @ApiModelProperty(value = "发货含税金额")
    private BigDecimal doAmt;

    @ApiModelProperty(value = "发货税额")
    private BigDecimal doTaxAmt;

    @ApiModelProperty(value = "签收数量")
    private BigDecimal confirmQty;

    @ApiModelProperty(value = "签收含税金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty(value = "签收税额")
    private BigDecimal confirmTaxAmt;

    @ApiModelProperty(value = "本次对账数量")
    private BigDecimal soaQty;

    @ApiModelProperty(value = "对账含税金额")
    private BigDecimal soaAmt;

    @ApiModelProperty(value = "对账税额")
    private BigDecimal soaTaxAmt;

    @ApiModelProperty(value = "签收日期")
    private LocalDateTime confirmTime;

    @ApiModelProperty(value = "发货时间")
    private LocalDateTime docTime;

    @ApiModelProperty(value = "实发数量")
    private BigDecimal doQty2;

    @ApiModelProperty(value = "签收不含税金额")
    private BigDecimal confirmNetAmt;

    @ApiModelProperty(value = "订单不含税金额")
    private BigDecimal soNetAmt;

    @ApiModelProperty(value = "订单含税价格")
    private BigDecimal soPrice;

    @ApiModelProperty(value = "订单未含税价格")
    private BigDecimal soNetPrice;

    @ApiModelProperty(value = "应税物货应税劳务、服务名称")
    private String taxClassDesc;

    @ApiModelProperty(value = "税收分类编码")
    private String taxClass;

    @ApiModelProperty("合同id")
    private Long contractId;
    @ApiModelProperty("合同code")
    private String contractCode;
    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("三级品类名称")
    private String thirdCateName;

    @ApiModelProperty("应收款余额(对账单分页反查专用)")
    private BigDecimal apAmt;
    @ApiModelProperty("已收款金额(对账单分页反查专用)")
    private BigDecimal payedAmt;
    @ApiModelProperty("收款中金额(对账单分页反查专用)")
    private BigDecimal payingAmt;
    @ApiModelProperty("待收款金额(对账单分页反查专用)")
    private BigDecimal openAmt;
    @ApiModelProperty("已开票金额(对账单分页反查专用)")
    private BigDecimal invedAmt;
    @ApiModelProperty("开票中金额(对账单分页反查专用)")
    private BigDecimal invingAmt;
    @ApiModelProperty("待开票金额(对账单分页反查专用)")
    private BigDecimal noinvAmt;
    @ApiModelProperty("已开票数量(对账单分页反查专用)")
    private BigDecimal invedQty;
    @ApiModelProperty("开票中数量(对账单分页反查专用)")
    private BigDecimal invingQty;
    @ApiModelProperty("待开票数量(对账单分页反查专用)")
    private BigDecimal noinvQty;
}
