package com.elitesland.yst.production.sale.api.vo.resp.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/27
 */
@Data
@ApiModel(description = "已上架商品")
public class BipItemOnShelfRespVO implements Serializable {
    private static final long serialVersionUID = -7105489358294836477L;

    @ApiModelProperty(value = "商品ID")
    private Long id;

    @ApiModelProperty(value = "上架编码", position = 1)
    private String shelfCode;

    @ApiModelProperty(value = "状态 [UDC]SAL:ITEM_STATE", position = 2)
    private String state;

    @ApiModelProperty(value = "状态名称", position = 2)
    private String stateName;

    @ApiModelProperty(value = "商品ID", position = 3)
    private Long itemId;

    @ApiModelProperty(value = "商品编码", position = 3)
    private String itemCode;

    @ApiModelProperty(value = "商品名称", position = 3)
    private String itemName;

    @ApiModelProperty(value = "一级商品分类名称", position = 4)
    private String categoryName1;

    @ApiModelProperty(value = "二级商品分类名称", position = 5)
    private String categoryName2;

    @ApiModelProperty(value = "三级商品分类名称", position = 6)
    private String categoryName3;

    @ApiModelProperty(value = "所属公司编码", position = 7)
    private String ouCode;

    @ApiModelProperty(value = "所属公司名称", position = 7)
    private String ouName;

    @ApiModelProperty(value = "运费收费方式 - 是否包邮", position = 8)
    private Boolean fareFree;

    @ApiModelProperty(value = "运费模板编号", position = 9)
    private String fareTmplCode;

    @ApiModelProperty(value = "运费模板名称", position = 9)
    private String fareTmplName;

    @ApiModelProperty(value = "创建人", position = 10)
    private String creator;

    @ApiModelProperty(value = "创建时间", position = 11)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "是否部分商品缺货", position = 12)
    private Boolean lackStock;
}
