package com.elitesland.yst.production.sale.api.vo.resp.shop.app;

import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Shadow
 */
@Data
@ApiModel(description = "证照信息列表数据")
public class BipCustQualifyRespVO {

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qualifyOuId;

    @ApiModelProperty(value = "证照编号")
    private String qualifyNo;

    @ApiModelProperty(value = "证照类型")
    private String qualifyType;
    private String qualifyTypeName;

    @ApiModelProperty(value = "证照状态")
    private String qualifyStatus;
    private String qualifyStatusName;

    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "附件")
    private List<ComSaleFileComVO> enclosure;
}
