package com.elitesland.yst.production.sale.api.vo.resp.shop.app;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/26/10:30
 * @Description:
 */
@Data
@ApiModel(description = "评价详情")
public class BipItemEvalDetailAppRespVO implements Serializable {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("订单主表id")
    private Long orderId;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("订单明细表id")
    private Long orderDId;

    @ApiModelProperty("商品id")
    private Long itemId;


    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品skuid")
    private Long skuId;

    @ApiModelProperty("商品sku编码")
    private String skuCode;

    @ApiModelProperty("总评价数")
    private Long numEval;

    @ApiModelProperty("好评数量")
    private Long numEvalGood;


    @ApiModelProperty("好评率")
    private BigDecimal rateEvalGood;

    @ApiModelProperty("好评率，分值形式")
    private BigDecimal scoreEval;

    @ApiModelProperty("商品属性")
    private String itemAttr;

    @ApiModelProperty("账户id")
    private Long custAccountId;

    @ApiModelProperty("账户名称")
    private String custAccountName;

    @ApiModelProperty("账户绑定电话")
    private String tel;

    @ApiModelProperty("评价内容")
    private String context;

    @ApiModelProperty("客户公司id")
    private Long ouId;

    @ApiModelProperty("客户公司编码")
    private String ouCode;

    @ApiModelProperty("客户公司名称")
    private String ouName;

    @ApiModelProperty("是否已回复 0 未回复 1 回复")
    private String isReplay;

    @ApiModelProperty("回复者id")
    private Long replayUserId;

    @ApiModelProperty("回复者名称")
    private String replayName;

    @ApiModelProperty("回复内容")
    private String replayContext;

    @ApiModelProperty("回复时间")
    private LocalDateTime replayTime;


    @ApiModelProperty("商品评分")
    private String itemEvalScore;


    @ApiModelProperty("物流评分")
    private String logicEvalScore;

    @ApiModelProperty("评价图片")
    private String evalFileCodes;

    @ApiModelProperty("评价文件信息")
    private List<FileObjRespVO> fileObjRespVOList;

    @ApiModelProperty("是否显示")
    private Boolean isShow;

    @ApiModelProperty("评价时间")
    private LocalDateTime createTime;

    @ApiModelProperty("是否公开 0 公开 1 不公开")
    private Boolean isPublic;

    @ApiModelProperty("用户头像在文件服务器中的标识")
    private String avatarCode;

    @ApiModelProperty("商品主图")
    private String itemPicFileCode;

}
