package com.elitesland.yst.production.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;


/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 业务员任务管理-任务明细表
 */
@Data
@ApiModel(description = "任务明细表")
public class TaskInfoDtlRespVO extends BaseModelVO implements Serializable{

    private static final long serialVersionUID = 9133717833214238241L;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("行号")
    private Integer lineNo;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-sale", mod = "TASK_BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("业务编码")
    private String businessCode;
    @ApiModelProperty("业务编码集合")
    private List<String> businessCodes;

    @ApiModelProperty("业务id")
    private Long businessId;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("经销商id")
    private Long dealerId;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty("营业时间")
    private String businessTime;

    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区")
    private String district;
    private String districtName;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("完成状态")
    @SysCode(sys = "yst-sale", mod = "TASK_COMPLETION_STATUS")
    private String completeState;
    private String completeStateName;

    @ApiModelProperty("是否逾期")
    @SysCode(sys = "yst-sale", mod = "TASK_DELAY_FLAG")
    private String delayFlag;
    private String delayFlagName;

    @ApiModelProperty("执行记录")
    private String executRecordName;

    @ApiModelProperty("执行记录id")
    private Long executRecordId;

    @ApiModelProperty("执行记录code")
    private String executRecordCode;

    @ApiModelProperty("经度")
    private String xLon;

    @ApiModelProperty("纬度")
    private String yLat;

    @ApiModelProperty("经纬度标准")
    private String coordType;

    @ApiModelProperty(value = "业务员员工ID")
    private Long employeeId;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    @ApiModelProperty("管辖区域名称")
    private String jurisdictionName;

    @ApiModelProperty("经度")
    private Double longitude;

    public String getXLon() {
        if (Objects.nonNull(longitude)) {
            xLon = String.valueOf(longitude);
        }
        return xLon;
    }

    @ApiModelProperty("纬度")
    private Double latitude;

    public String getYLat() {
        if (Objects.nonNull(latitude)) {
            yLat = String.valueOf(latitude);
        }
        return yLat;
    }


}
