package com.elitesland.yst.production.sale.api.vo.resp.taskinfo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/08
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "任务主表和明细导出出参对象")
public class TaskInfoExportRespVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = 4906627943985491200L;

    @ApiModelProperty("任务编码")
    private String code;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务状态")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_STATUS")
    private String state;
    private String stateName;

    @ApiModelProperty("发布人")
    private String publishUser;
    @ApiModelProperty("发布人id")
    private Long publishUserId;
    @ApiModelProperty("发布人code")
    private String publishUserCode;

    @ApiModelProperty("是否逾期")
    @SysCode(sys = "yst-sale", mod = "TASK_DELAY_FLAG")
    private String delayFlag;
    private String delayFlagName;

    @ApiModelProperty("任务进度")
    private BigDecimal progress;
    @ApiModelProperty("任务进度字符串")
    private String progressStr;

    @ApiModelProperty("任务类型")
    @SysCode(sys = "yst-sale", mod = "SALESMAN_TASK_TYPE")
    private String type;
    private String typeName;

    @ApiModelProperty("所属公司")
    private String ouCode;
    @ApiModelProperty("所属公司名称")
    private String ouName;

    @ApiModelProperty("紧急程度")
    @SysCode(sys = "yst-sale", mod = "TASK_URGENCY_LEVEL")
    private String urgencyLevel;
    private String urgencyLevelName;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("完成时间")
    private LocalDateTime completeTime;

    @ApiModelProperty("任务描述")
    private String taskDesc;

    /**************************/

    @ApiModelProperty("重复设置")
    private String repeatSet;
    //private String repeatSetName;

    @ApiModelProperty("重复类型（次/天/周/月）")
    private String repeatType;
    //private String repeatTypeName;

    @ApiModelProperty("重复间隔")
    private BigDecimal repeatInterval;

    @ApiModelProperty("指定天")
    private String appointDay;
    private String appointDayName;

    @ApiModelProperty("重复开始时间")
    private LocalDateTime repeatStartTime;

    @ApiModelProperty("重复结束时间")
    private LocalDateTime repeatEndTime;

    @ApiModelProperty("执行时间")
    private LocalDateTime executTime;

    @ApiModelProperty("活动编码")
    private String promotionCode;

    @ApiModelProperty("活动名称")
    private String promotionName;

    @ApiModelProperty("强制签到")
    @SysCode(sys = "yst-sale", mod = "TASK_FORCE_SIGN_FLAG")
    private String forceSignFlag;
    private String forceSignFlagName;

    @ApiModelProperty("签到范围")
    private BigDecimal signInRange;

    @ApiModelProperty("签退范围")
    private BigDecimal signOutRange;

    @ApiModelProperty("执行模板")
    private String executTemplate;

    @ApiModelProperty("文件信息")
    private String fileInfo;
    @ApiModelProperty("附件编码集合")
    private List<String> fileCodes;

    @ApiModelProperty("执行模板id")
    private Long executTemplateId;

    @ApiModelProperty("执行模板code")
    private String executTemplateCode;

    @ApiModelProperty("执行模板名称")
    private String executTemplateName;

    /*******************任务明细字段开始***************************/

    @ApiModelProperty("明细id")
    private Long dtlId;

    @ApiModelProperty("关联id")
    private Long masId;

    @ApiModelProperty("行号")
    private Integer lineNo;

    @ApiModelProperty("业务类型")
    @SysCode(sys = "yst-sale", mod = "TASK_BUSINESS_TYPE")
    private String businessType;
    private String businessTypeName;

    @ApiModelProperty("业务编码")
    private String businessCode;
    @ApiModelProperty("业务编码集合")
    private List<String> businessCodes;

    @ApiModelProperty("业务id")
    private Long businessId;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("经销商id")
    private Long dealerId;

    @ApiModelProperty("经销商编码")
    private String dealerCode;

    @ApiModelProperty("经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "客户号")
    private String custCode2;

    @ApiModelProperty("营业时间")
    private String businessTime;

    @ApiModelProperty("国家")
    private String country;
    private String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区")
    private String district;
    private String districtName;

    @ApiModelProperty("省市区拼接")
    private String regionStr;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("执行人")
    private String executUser;

    @ApiModelProperty("执行人id")
    private Long executUserId;

    @ApiModelProperty("执行人code")
    private String executUserCode;

    @ApiModelProperty("明细完成时间")
    private LocalDateTime dtlCompleteTime;

    @ApiModelProperty("完成状态")
    @SysCode(sys = "yst-sale", mod = "TASK_COMPLETION_STATUS")
    private String completeState;
    private String completeStateName;

    @ApiModelProperty("明细是否逾期")
    @SysCode(sys = "yst-sale", mod = "TASK_DELAY_FLAG")
    private String dtlDelayFlag;
    private String dtlDelayFlagName;

    /*******************************************/

    @ApiModelProperty("执行记录")
    private String executRecordName;

    @ApiModelProperty("执行记录id")
    private Long executRecordId;

    @ApiModelProperty("执行记录code")
    private String executRecordCode;

    @ApiModelProperty("经度")
    private String xLon;

    @ApiModelProperty("纬度")
    private String yLat;

    @ApiModelProperty("经纬度标准")
    private String coordType;

    @ApiModelProperty(value = "业务员员工ID")
    private Long employeeId;

    @ApiModelProperty(value = "联系人")
    private String contactName;

    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    /*******************任务明细字段结束***************************/

    @ApiModelProperty("经度")
    private Double longitude;

    public String getXLon() {
        if (Objects.nonNull(longitude)) {
            xLon = String.valueOf(longitude);
        }
        return xLon;
    }

    @ApiModelProperty("纬度")
    private Double latitude;

    public String getYLat() {
        if (Objects.nonNull(latitude)) {
            yLat = String.valueOf(latitude);
        }
        return yLat;
    }

}
