package com.elitesland.yst.production.sale.api.vo.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4 20:04
 */
@Data
@ApiModel(description = "潜在客户表新增编辑入参")
public class CrmScustSaveVO implements Serializable {

    private static final long serialVersionUID = 7255830361535253227L;

    @ApiModelProperty(value = "客户id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "客户编码")
    private String custCode;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty(value = "外部系统客户编码")
    private String custCode2;

    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "客户名称", required = true)
    private String custName;

    @ApiModelProperty(value = "客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "英文名称")
    private String custName2;

    @ApiModelProperty(value = "公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "公司编号", required = true)
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "销售组织ID", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    @ApiModelProperty(value = "销售组织编号")
    private String buCode;
    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty(value = "区域", required = true)
    private String region;

    @ApiModelProperty(value = "客户管理专员id", required = true)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long agentEmpId;

    @ApiModelProperty(value = "客户分类", required = true)
    private String custType;

    @ApiModelProperty(value = "客户状态")
    private String custStatus;

    @ApiModelProperty(value = "意向登级")
    private String intentLevel;

    @ApiModelProperty(value = "最近跟进日期")
    private LocalDateTime lastFollowupDate;

    @ApiModelProperty(value = "客户等级")
    private String custLevel;

    @ApiModelProperty(value = "客户行业")
    private String custIndustry;

    @ApiModelProperty(value = "客户来源")
    private String custSource;

    @ApiModelProperty(value = "客户规模")
    private String compScale;

    @ApiModelProperty(value = "客户联系人")
    private String contPerson;

    @ApiModelProperty(value = "客户联系人电话")
    private String mobile;

    @ApiModelProperty(value = "客户联系人邮箱")
    private String email;

    @ApiModelProperty(value = "客户联系人详细地址")
    private String detailAddr;

    @ApiModelProperty(value = "客户年营业额")
    private String compTurnover;

    @ApiModelProperty(value = "客户归类")
    private String custType2;

    @ApiModelProperty(value = "父项客户号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;

    @ApiModelProperty(value = "是否是燃气用户 0:是 | 1:否")
    private String es2;

    @ApiModelProperty(value = "其他1")
    private String es3;

    @ApiModelProperty(value = "其他2")
    private String es4;

    @ApiModelProperty(value = "其他3")
    private String es5;

    @ApiModelProperty(value = "其他4")
    private String es6;

    @ApiModelProperty(value = "其他5")
    private String es7;

    @ApiModelProperty(value = "其他6")
    private String es8;

    @ApiModelProperty(value = "客户详情")
    private String es9;

}
