package com.elitesland.yst.production.sale.api.vo.save;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/12 16:17
 */
@Data
@ApiModel(description = "合同详情商品导入模板")
public class SalContractItemImportSaveVO implements Serializable {
    private static final long serialVersionUID = 4064430030763431500L;

    @ApiModelProperty("新零售系统的商品编码")
    private String custItemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品规格名称")
    private String itemSpec;

    @ApiModelProperty("客户商品编码")
    private String itemCode;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否供应商代发")
    private Boolean suppFlag;
    private String suppFlagName;

    @ApiModelProperty("数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "计量单位 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp",mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("含税价格")
    private BigDecimal price;

    @ApiModelProperty("含税金额")
    private BigDecimal amt;

    /*
     *  补充字段
     */
    @ApiModelProperty("基础价格")
    private BigDecimal basePrice;

    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣不含税金额")
    private BigDecimal discNetAmt;

    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;

    @ApiModelProperty("总毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("商品品牌")
    private String itemBrand;
    private String itemBrandName;

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("行号")
    private BigDecimal lineNo;

    @ApiModelProperty("主表ID")
    private Long masId;

    @ApiModelProperty("未税金额")
    private BigDecimal netAmt;

    @ApiModelProperty("未税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("总净重")
    private BigDecimal netWeight;

    @ApiModelProperty("单个毛重")
    private BigDecimal signGrossWeight;

    @ApiModelProperty("单个净重")
    private BigDecimal signNetWeight;

    @ApiModelProperty("单个体积")
    private BigDecimal signVolume;

    @ApiModelProperty("税额")
    private BigDecimal taxAmt;

    @ApiModelProperty("税率编码")
    private String taxCode;
    private String taxRateDesc;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    private BigDecimal taxRatePercent;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("运输方式")
    private String transType;
    private String transTypeName;

    @ApiModelProperty("总体积")
    private BigDecimal volume;

    @ApiModelProperty("体积单位")
    private String volumeUom;

    @ApiModelProperty("重量单位")
    private String weightUom;

}
