package com.elitesland.yst.production.sale.api.vo.save;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * @author : WWW
 * @date : 2023-6-1
 * @desc : 销售业绩统计-经销商
 */

@Data
@ApiModel(description = "销售业绩统计-经销商")
public class SaleStatisticsDealerSaveVO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 2735621682844812126L;

    /**
     * 统计时间
     */
    @ApiModelProperty("统计时间")
    private LocalDateTime docTime;

    /**
     * 经销商编码
     */
    @ApiModelProperty("经销商编码")
    private String dealerCode;

    /**
     * 经销商名称
     */
    @ApiModelProperty("经销商名称")
    private String dealerName;

    /**
     * 经销商客户号
     */
    @ApiModelProperty("经销商客户号")
    private String dealerSerialNo;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String type;

    /**
     * 业务员关系路径
     */
    @ApiModelProperty("业务员关系路径")
    private String salesmanPath;

    /**
     * 车型
     */
    @ApiModelProperty("车型")
    private String vehicleType;

    /**
     * 出货量
     */
    @ApiModelProperty("出货量")
    private BigDecimal shipQty;

    /**
     * 订货量
     */
    @ApiModelProperty("订货量")
    private BigDecimal orderQty;
    /**
     * 客户类型
     */
    @ApiModelProperty("客户类型")
    private String custType;
    /**
     * 整车类型
     */
    @ApiModelProperty("整车类型")
    private String itemType3;

    /**
     * 更新区域失败原因
     */
    @ApiModelProperty("更新区域失败原因")
    private String updateRegionFailureReason;

    /**
     * 更新业务员失败原因
     */
    @ApiModelProperty("更新业务员失败原因")
    private String updateSalesmanFailureReason;


    /*@ApiModelProperty("业务员明细")
    private List<SaleStatisticsDealerDtlSaveVO> dtlSaveVOList;*/

}

