package com.elitesland.yst.production.sale.api.vo.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/17
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(description = "任务重复设置保存对象入参")
public class TaskRepeatSetSaveVO implements Serializable {
    private static final long serialVersionUID = 6987016966064935616L;

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty("重复设置")
    private String repeatSet;

    @ApiModelProperty("重复类型（次/天/周/月）")
    private String repeatType;

    @ApiModelProperty("重复间隔")
    private BigDecimal repeatInterval;

    @ApiModelProperty("指定天")
    private String appointDay;

    @ApiModelProperty("重复开始时间")
    private LocalDateTime repeatStartTime;

    @ApiModelProperty("重复结束时间")
    private LocalDateTime repeatEndTime;

    @ApiModelProperty("执行时间")
    private LocalDateTime executTime;

}
