package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
@Data
@ApiModel(description = "保存用户绑定信息")
public class BipCustUserBindSaveVO implements Serializable {
    private static final long serialVersionUID = -8356114993621301478L;

    @ApiModelProperty(value = "企业名称", required = true, position = 1)
    @NotBlank(message = "企业全称不能为空")
    @Size(max = 64, message = "公司名称长度限制为64")
    private String custName;

    @ApiModelProperty(value = "纳税人识别号", required = true, position = 2)
    @NotBlank(message = "纳税人识别号不能为空")
    @Size(max = 64, message = "纳税人识别号长度限制为64")
    private String taxRegNo;

    @ApiModelProperty(value = "联系人", required = true, position = 3)
    @NotBlank(message = "联系人不能为空")
    @Size(max = 32, message = "联系人长度限制为32")
    private String contactName;

    @ApiModelProperty(value = "联系人电话", required = true, position = 4)
    @NotBlank(message = "联系人电话不能为空")
    @Size(max = 32, message = "联系人电话长度限制为32")
    private String contactPhone;

    @ApiModelProperty(value = "短信验证码", required = true, position = 5)
    @NotBlank(message = "验证码不能为空")
    private String verifyCode;

    @ApiModelProperty(value = "营业执照文件的标识", required = true, position = 6)
    @NotBlank(message = "请上传营业执照")
    private String certFileCode;

    @ApiModelProperty(value = "公司ID", required = true, position = 7)
    @NotNull(message = "请选择关联公司")
    private Long ouId;
}
