package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/09/23/18:24
 * @Description:
 */
@Data
@ApiModel(description = "商品评价详细信息")
public class BipItemEvalDetailSaveVO implements Serializable {


    private static final long serialVersionUID = 7194746641645436823L;


    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("订单主表id")
    private Long orderId;

    @ApiModelProperty("订单号")
    private String docNo;

    @ApiModelProperty("订单明细表id")
    private Long orderDId;

    @ApiModelProperty("商品id")
    private Long itemId;


    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("商品skuid")
    private Long skuId;

    @ApiModelProperty("商品sku编码")
    private String skuCode;
    @ApiModelProperty("账户id")
    private Long custAccountId;

    @ApiModelProperty("账户名称")
    private String custAccountName;

    @ApiModelProperty("账户绑定电话")
    private String tel;

    @ApiModelProperty("评价内容")
    private String context;

    @ApiModelProperty("客户公司id")
    private Long ouId;

    @ApiModelProperty("客户公司编码")
    private String ouCode;

    @ApiModelProperty("客户公司名称")
    private String ouName;

    @ApiModelProperty("是否已回复")
    private Boolean isReplay;

    @ApiModelProperty("回复者id")
    private Long replayUserId;

    @ApiModelProperty("回复者名称")
    private String replayName;

    @ApiModelProperty("回复内容")
    private String replayContext;

    @ApiModelProperty("回复时间")
    private LocalDateTime replayTime;


    @ApiModelProperty("商品评分")
    private String itemEvalScore;


    @ApiModelProperty("评价图片")
    private String evalFileCodes;

    @ApiModelProperty("是否显示")
    private Boolean isShow;

    @ApiModelProperty("是否公开 0 公开 1 不公开")
    private Boolean isPublic;


}
