package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/23
 */
@Data
@ApiModel(description = "商品SKU属性")
public class BipItemSkuAttrSaveVO implements Serializable {
    private static final long serialVersionUID = 2557835178631098646L;

    @ApiModelProperty(value = "属性编码", position = 1, required = true)
    @NotBlank(message = "属性编码不能为空")
    private String code;

    @ApiModelProperty(value = "属性名称", position = 2, required = true)
    @NotBlank(message = "属性名称不能为空")
    private String name;

    @ApiModelProperty(value = "属性值", position = 3, required = true)
    @NotBlank(message = "属性值不能为空")
    private String value;
}
