package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/19
 */
@Data
@ApiModel(description = "商品SKU信息")
public class BipItemSkuSaveVO implements Serializable {
    private static final long serialVersionUID = 2435706710406719433L;

    @ApiModelProperty(value = "商品名称", position = 1, required = true)
    @NotBlank(message = "商品名称不能为空")
    @Size(min = 1, max = 128, message = "SKU商品名称长度限制为128")
    private String itemName;

    @ApiModelProperty(value = "sku编号", position = 2, required = true)
    @NotBlank(message = "sku编号不能为空")
    @Size(min = 1, max = 64, message = "SKU商品名称长度限制为64")
    private String skuCode;

    @ApiModelProperty(value = "商品属性", position = 3)
    @Valid
    private List<BipItemSkuAttrSaveVO> attrList;

    @ApiModelProperty(value = "包装规格", position = 4)
    @Size(max = 256, message = "包装规格长度限制为256")
    private String spec;

    @ApiModelProperty(value = "商品条码", position = 5)
    @Size(max = 256, message = "商品条码长度限制为256")
    private String barcode;

    @ApiModelProperty(value = "品牌", position = 6)
    @Size(max = 256, message = "品牌长度限制为256")
    private String brand;

    @ApiModelProperty(value = "批次", position = 7)
    @Size(max = 256, message = "批次长度限制为256")
    private String batch;

    @ApiModelProperty(value = "物料类型", position = 8)
    @Size(max = 256, message = "物料类型长度限制为256")
    private String materiel;

    @ApiModelProperty(value = "商品类型", position = 9)
    @Size(max = 256, message = "商品类型长度限制为256")
    private String type;

    @ApiModelProperty(value = "B端指导价", position = 10)
    private BigDecimal priceGuide;

    @ApiModelProperty(value = "基础价", position = 11, required = true)
    @NotNull(message = "基础价不能为空")
    private BigDecimal price;

    @ApiModelProperty(value = "是否一件代发", position = 12)
    private Boolean shipOne;

    @ApiModelProperty(value = "供应商", position = 13)
    @Size(max = 256, message = "供应商长度限制为256")
    private String supplier;

    @ApiModelProperty(value = "库存", position = 14)
    @Min(value = 0, message = "库存不能小于0")
    private Integer stock;

    @ApiModelProperty(value = "最小起订量", position = 15)
    @Min(value = 1, message = "最小起订量不能小于1")
    private Integer limitBuy;

    @ApiModelProperty(value = "冻结状态 true：冻结  false：未冻结", position = 16)
//    @NotNull(message = "冻结状态不能为空")
    private Boolean freeze;

}
