package com.elitesland.yst.production.sale.api.vo.save.shop;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/30
 */
@Data
@ApiModel(description = "商品库存调整")
public class BipItemStockSaveVO implements Serializable {
    private static final long serialVersionUID = 1231601525977646077L;

    @ApiModelProperty(value = "SKU记录ID", position = 1)
    @NotNull(message = "未知SKU记录")
    private Long skuId;

    @ApiModelProperty(value = "库存", position = 2)
    @NotNull(message = "库存不能为空")
    @Min(value = 0, message = "库存最小限制为0")
    private Integer stock;
}
