package com.elitesland.yst.production.sale.dto.query;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 价格查询商品封装数据
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/5 1:26 下午
 */
@Data
public class PriSaleItemReqDTO implements Serializable {
    private static final long serialVersionUID = -3996309867241281361L;

    /**
     * 商品ID
     */
    @NotNull(message = "商品ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 计量单位
     */
    @NotBlank(message = "计量单位不得为空")
    private String uom;

}
