package com.elitesland.yst.production.sale.dto.query;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 查询参数 - 对外销售价格
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 2:07
 */
@Data
public class PriSalePriceReqDTO implements Serializable {

    private static final long serialVersionUID = 248246885360178612L;

    /**
     * 销售公司ID
     */
    @NotNull(message = "公司ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 客户ID
     */
//    @NotNull(message = "客户ID不得为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long custId;
    private String custCode;

    /**
     * 货币码
     */
    //@NotEmpty(message = "货币码不得为空")
    private String currCode;

    /**
     * 商品集合
     */
    @NotEmpty(message = "查询商品集合不得为空")
    @Valid
    private List<PriSaleItemReqDTO> items;

    /**
     * 是否直接返回错误标识
     * true：只要存在未查找到价格的商品时，响应非200，msg为错误信息
     * false或不传：存在未查找到价格的商品时，仍然响应200，data中明细有对应错误信息，其他查到价格的商品正常返回
     */
    private Boolean failFast;

}
